_G.PersonOfHourai = _G.PersonOfHourai or {}
PersonOfHourai.path = ModPath
PersonOfHourai.data_path = SavePath .. "peron_of_hourai.txt"
PersonOfHourai.settings = {
	PersonOfHourai_HUD_Enable = true,
	poh_hud_x = 627,
	poh_hud_y = 484,
	poh_hud_align = 3
}

function PersonOfHourai:Save()
	local file = io.open(self.data_path, "w+")
	if file then
		file:write(json.encode(self.settings))
		file:close()
	end
end

function PersonOfHourai:Load()
	local file = io.open(self.data_path, "r")
	if file then
		local options = json.decode(file:read("*all"))
		for key, ops in pairs(options) do
			self.settings[key] = ops
		end
		file:close()
	end
end

Hooks:Add("MenuManagerInitialize", "MenuManagerInitialize_PersonOfHourai", function(menu_manager)
	MenuCallbackHandler.PersonOfHourai_OptionsSave = function(this, item)
		PersonOfHourai:Save()
	end
	
	MenuCallbackHandler.PersonOfHouraiCheckbox_MenuCallback = function(this, item)
		PersonOfHourai.settings[item:name()] = item:value() == 'on'
	end
	
	MenuCallbackHandler.PersonOfHouraiSlider_MenuCallback = function(this, item)
		PersonOfHourai.settings[item:name()] = item:value()
		
		if PersonOfHourai.hud then
			PersonOfHourai.hud:set_poh_position(item:name(), item:value())
		end
	end	

	MenuCallbackHandler.PersonOfHouraiAlignMulti_MenuCallback = function(this, item)
		PersonOfHourai.settings[item:name()] = item:value()
	end
	
	PersonOfHourai:Load()
	MenuHelper:LoadFromJsonFile(PersonOfHourai.path .. 'menu/options.txt', PersonOfHourai, PersonOfHourai.settings)
end)